<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\File;

use Dedi\SyliusAvisVerifiesPlugin\File\ValueObject\ImportFile;

interface FileImporterInterface
{
    public function import(string $filePrefix, bool $sortDescending = true): ImportFile;

    /** @return ImportFile[]|array */
    public function importAll(string $filePrefix): array;

    public function archiveFile(ImportFile $file): void;
}
