<?php

declare(strict_types=1);

namespace Dedi\SyliusAvisVerifiesPlugin\Client\ValueObject;

class Credentials implements CredentialsInterface
{
    public function __construct(
        private readonly string $clientId,
        private readonly string $secretKey,
        private readonly string $websiteId,
    ) {
    }

    public function getClientId(): string
    {
        return $this->clientId;
    }

    public function getSecretKey(): string
    {
        return $this->secretKey;
    }

    public function getWebsiteId(): string
    {
        return $this->websiteId;
    }
}
