<?php

declare(strict_types=1);

namespace Tests\Dedi\SyliusAclPlugin\Entity;

use Dedi\SyliusAclPlugin\Model\AdminUserInterface;
use Dedi\SyliusAclPlugin\Model\PermissionCheckerTrait;
use Dedi\SyliusAclPlugin\Model\RoleAwareTrait;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\AdminUser as BaseAdminUser;

#[ORM\Entity]
#[ORM\Table(name: 'sylius_admin_user')]
class AdminUser extends BaseAdminUser implements AdminUserInterface
{
    use RoleAwareTrait {
        __construct as protected initializeAclRoles;
    }
    use PermissionCheckerTrait;

    #[ORM\Column(type: 'boolean')]
    protected bool $permissionChecker = false;

    #[ORM\ManyToMany(targetEntity: 'Dedi\SyliusAclPlugin\Entity\Role')]
    #[ORM\JoinTable(name: 'dedi_acl_admin_users_roles')]
    #[ORM\JoinColumn(name: 'admin_user_id', referencedColumnName: 'id', unique: false)]
    #[ORM\InverseJoinColumn(name: 'acl_role_id', referencedColumnName: 'id', unique: false)]
    protected Collection $aclRoles;

    public function __construct()
    {
        parent::__construct();

        $this->initializeAclRoles();
    }
}
