<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Twig;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class SettingsCheckerExtension extends AbstractExtension
{
    public function __construct(private SettingsProviderInterface $settingsProvider)
    {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('dedi_sylius_acl_is_enabled', [$this, 'isEnabled']),
        ];
    }

    public function isEnabled(): bool
    {
        $settings = $this->settingsProvider->provide();

        return $settings->isEnabled();
    }
}
