<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Twig;

use Dedi\SyliusAclPlugin\Resolver\PermissionResolverInterface;
use Symfony\Bridge\Twig\Extension\RoutingExtension as BaseRoutingExtension;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class RoutingExtension extends AbstractExtension
{
    public const ACL_ACCESS_DENIED = '#ACL_ACCESS_DENIED';

    public function __construct(
        private BaseRoutingExtension $baseRoutingExtension,
        protected UrlGeneratorInterface $generator,
        protected PermissionResolverInterface $adminPermissionResolver,
    ) {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('url', [$this, 'getUrl'], ['is_safe_callback' => [$this->baseRoutingExtension, 'isUrlGenerationSafe']]),
            new TwigFunction('path', [$this, 'getPath'], ['is_safe_callback' => [$this->baseRoutingExtension, 'isUrlGenerationSafe']]),
        ];
    }

    public function getPath(
        string $name,
        array $parameters = [],
        bool $relative = false,
    ): string {
        if (!$this->adminPermissionResolver->hasPermission($name)) {
            return self::ACL_ACCESS_DENIED;
        }

        return $this->baseRoutingExtension->getPath($name, $parameters, $relative);
    }

    public function getUrl(
        string $name,
        array $parameters = [],
        bool $schemeRelative = false,
    ): string {
        if (!$this->adminPermissionResolver->hasPermission($name)) {
            return self::ACL_ACCESS_DENIED;
        }

        return $this->baseRoutingExtension->getUrl($name, $parameters, $schemeRelative);
    }
}
