<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Twig;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusAclPlugin\Resolver\PermissionResolverInterface;
use Sylius\Bundle\ResourceBundle\Grid\View\ResourceGridView;
use Sylius\Component\Grid\Definition\Action;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

final class PermissionExtension extends AbstractExtension
{
    public function __construct(
        private PermissionResolverInterface $permissionResolver,
        private SettingsProviderInterface $settingsProvider,
    ) {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('dedi_acl_has_permission', [$this, 'hasPermission']),
            new TwigFunction('dedi_acl_get_grid_actions', [$this, 'getGridActions']),
        ];
    }

    public function hasPermission(string $permission): bool
    {
        return $this->permissionResolver->hasPermission($permission);
    }

    /** @param array<Action> $actions */
    public function getGridActions(
        ResourceGridView $resourceGridView,
        array $actions,
        bool $isBulkAction = false,
    ): array {
        $settings = $this->settingsProvider->provide();

        if (!$settings->isEnabled()) {
            return $actions;
        }

        $requestConfiguration = $resourceGridView->getRequestConfiguration();

        foreach ($actions as $key => $action) {
            if ('links' !== $action->getType()) {
                if (isset($action->getOptions()['link']['route'])) {
                    $permission = $action->getOptions()['link']['route'];
                } else {
                    $name = $isBulkAction ? 'bulk_' . $action->getType() : $action->getType();
                    $permission = $requestConfiguration->getRouteName($name);
                }

                if (!$this->permissionResolver->hasPermission($permission)) {
                    unset($actions[$key]);
                }

                continue;
            }

            $options = $action->getOptions();

            foreach ($options['links'] as $name => $link) {
                if (!isset($link['route'])) {
                    continue;
                }

                if (!$this->permissionResolver->hasPermission($link['route'])) {
                    unset($options['links'][$name]);
                }
            }

            $action->setOptions($options);

            if (0 === count($options['links'])) {
                unset($actions[$key]);
            }
        }

        return $actions;
    }
}
