<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Twig;

use Symfony\Bridge\Twig\Extension\HttpKernelRuntime;
use Symfony\Component\HttpKernel\Controller\ControllerReference;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class HttpKernelExtension extends AbstractExtension
{
    public function __construct(
        private HttpKernelRuntime $httpKernelRuntime,
    ) {
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('render', [$this, 'renderFragment'], ['is_safe' => ['html']]),
            new TwigFunction('render_*', [HttpKernelRuntime::class, 'renderFragmentStrategy'], ['is_safe' => ['html']]),
            new TwigFunction('fragment_uri', [HttpKernelRuntime::class, 'generateFragmentUri']),
            new TwigFunction('controller', [self::class, 'controller']),
        ];
    }

    public function renderFragment(string|ControllerReference $uri, array $options = []): ?string
    {
        if (RoutingExtension::ACL_ACCESS_DENIED === $uri) {
            return '';
        }

        return $this->httpKernelRuntime->renderFragment($uri, $options);
    }

    public static function controller(string $controller, array $attributes = [], array $query = []): ControllerReference
    {
        return new ControllerReference($controller, $attributes, $query);
    }
}
