<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Route\Label;

use Dedi\SyliusAclPlugin\Route\Checker\RouteCheckerInterface;
use Symfony\Component\Routing\Route;
use Webmozart\Assert\Assert;

class StateMachineRouteLabelResolver implements RouteLabelResolverInterface
{
    public function __construct(private RouteCheckerInterface $adminStateMachineRouteChecker)
    {
    }

    public function resolve(string $routeName, Route $route): ?string
    {
        if (false === $this->adminStateMachineRouteChecker->check($route)) {
            return null;
        }

        $syliusParameters = $route->getDefault('_sylius');

        if (!is_array($syliusParameters) || !array_key_exists('state_machine', $syliusParameters)) {
            return null;
        }

        $controller = $route->getDefault('_controller');
        Assert::string($controller);

        $alias = explode(':', explode('.', $controller)[2])[0];

        return sprintf('action.%s_%s', $alias, $syliusParameters['state_machine']['transition']);
    }
}
