<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Route\Label;

use Symfony\Component\Routing\Route;

class ParameterRouteLabelResolver implements RouteLabelResolverInterface
{
    public function resolve(string $routeName, Route $route): ?string
    {
        $defaults = $route->getDefault('_dedi_sylius_acl_plugin');

        if (\is_array($defaults) && array_key_exists('label', $defaults)) {
            return $defaults['label'];
        }

        return null;
    }
}
