<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Route\Label;

use Laminas\Stdlib\PriorityQueue;
use Symfony\Component\Routing\Route;

final class CompositeRouteLabelResolver implements RouteLabelResolverInterface
{
    /** @var PriorityQueue<RouteLabelResolverInterface, int> */
    private PriorityQueue $resolvers;

    public function __construct(
    ) {
        $this->resolvers = new PriorityQueue();
    }

    public function addRouteLabelResolver(RouteLabelResolverInterface $privilege, int $priority = 0): void
    {
        $this->resolvers->insert($privilege, $priority);
    }

    public function resolve(string $routeName, Route $route): ?string
    {
        foreach ($this->resolvers as $resolver) {
            if (null !== $label = $resolver->resolve($routeName, $route)) {
                return $label;
            }
        }

        return null;
    }
}
