<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Route\Label;

use Dedi\SyliusAclPlugin\Route\Checker\RouteCheckerInterface;
use Symfony\Component\Routing\Route;

class AdminPartialRouteLabelResolver implements RouteLabelResolverInterface
{
    public function __construct(private RouteCheckerInterface $adminPartialRouteChecker)
    {
    }

    public function resolve(string $routeName, Route $route): ?string
    {
        if (false === $this->adminPartialRouteChecker->check($route)) {
            return null;
        }

        return preg_replace('/\w{0,}(admin_partial)_/', 'partial.', $routeName);
    }
}
