<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Route\Label;

use Symfony\Component\Routing\Route;
use Webmozart\Assert\Assert;

class AdminAjaxRouteLabelResolver implements RouteLabelResolverInterface
{
    public function resolve(string $routeName, Route $route): ?string
    {
        $controller = $route->getDefault('_controller');
        Assert::string($controller);

        if (!str_contains($controller, ':')) {
            return $controller;
        }

        $alias = explode(':', explode('.', $controller)[2])[0];

        return preg_replace('/\w{0,}(' . $alias . ')_/', 'action.', $routeName);
    }
}
