<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Route\Checker;

use Laminas\Stdlib\PriorityQueue;
use Symfony\Component\Routing\Route;

final class CompositeRouteChecker implements RouteCheckerInterface
{
    /** @var PriorityQueue<RouteCheckerInterface, int> */
    private PriorityQueue $checkers;

    public function __construct()
    {
        $this->checkers = new PriorityQueue();
    }

    public function addRouteChecker(RouteCheckerInterface $checker, int $priority = 0): void
    {
        $this->checkers->insert($checker, $priority);
    }

    public function check(Route $route): bool
    {
        foreach ($this->checkers as $checker) {
            if ($checker->check($route)) {
                return true;
            }
        }

        return false;
    }
}
