<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Route\Checker;

use Symfony\Component\Routing\Route;
use Webmozart\Assert\Assert;

class AdminSectionRouteChecker implements RouteCheckerInterface
{
    public function check(Route $route): bool
    {
        if (!$route->hasDefault('_sylius')) {
            return false;
        }

        $syliusParameters = $route->getDefault('_sylius');
        Assert::isArray($syliusParameters);

        return array_key_exists('section', $syliusParameters) && str_contains($syliusParameters['section'], 'admin');
    }
}
