<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Provider;

use Dedi\SyliusAclPlugin\Model\AdminUserInterface;
use Symfony\Bundle\SecurityBundle\Security;

final class AdminUserProvider implements AdminUserProviderInterface
{
    public function __construct(
        private Security $security,
    ) {
    }

    public function provide(): ?AdminUserInterface
    {
        /** @var AdminUserInterface|null $user */
        $user = $this->security->getUser();

        if ($user instanceof AdminUserInterface) {
            return $user;
        }

        return null;
    }
}
