<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\PermissionMap;

use Laminas\Stdlib\PriorityQueue;
use Symfony\Contracts\Cache\CacheInterface;
use Symfony\Contracts\Cache\ItemInterface;
use Webmozart\Assert\Assert;

final class CompositePermissionMap implements PermissionMapInterface
{
    /** @var PriorityQueue<PermissionMapInterface, int> */
    private PriorityQueue $permissionMaps;

    public function __construct(
        private CacheInterface $cacheAdapter,
    ) {
        $this->permissionMaps = new PriorityQueue();
    }

    public function addPermissionMap(PermissionMapInterface $permissionMap, int $priority = 0): void
    {
        $this->permissionMaps->insert($permissionMap, $priority);
    }

    public function getMap(array $mapping = [], bool $isTree = false): array
    {
        $cacheKey = true === $isTree ? self::TREE_MAP_CACHE_KEY : self::PERMISSIONS_MAP_CACHE_KEY;

        $cachedPermissionMap = $this->cacheAdapter->get($cacheKey, function (ItemInterface $item) use (&$mapping, $isTree) {
            foreach ($this->permissionMaps as $permissionMap) {
                $mapping = $permissionMap->getMap($mapping, $isTree);
            }

            return $mapping;
        });

        Assert::isArray($cachedPermissionMap);

        return $cachedPermissionMap;
    }
}
