<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Model;

use Dedi\SyliusAclPlugin\Entity\RoleInterface;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

trait RoleAwareTrait
{
    /** @var Collection<RoleInterface> */
    protected Collection $aclRoles;

    public function __construct()
    {
        $this->aclRoles = new ArrayCollection();
    }

    public function getAclRoles(): Collection
    {
        return $this->aclRoles;
    }

    public function addAclRole(RoleInterface $role): static
    {
        if (!$this->hasAclRole($role)) {
            $this->aclRoles->add($role);
        }

        return $this;
    }

    public function removeAclRole(RoleInterface $role): static
    {
        if ($this->hasAclRole($role)) {
            $this->aclRoles->removeElement($role);
        }

        return $this;
    }

    public function hasAclRole(RoleInterface $role): bool
    {
        return $this->aclRoles->contains($role);
    }
}
