<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Model;

use Dedi\SyliusAclPlugin\Entity\RoleInterface;
use Doctrine\Common\Collections\Collection;

interface RoleAwareInterface
{
    /** @return Collection<int, RoleInterface> */
    public function getAclRoles(): Collection;

    public function addAclRole(RoleInterface $role): static;

    public function removeAclRole(RoleInterface $role): static;

    public function hasAclRole(RoleInterface $role): bool;
}
