<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Menu;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Knp\Menu\MenuItem;
use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

final class OrderShowMenuBuilder
{
    public function __construct(
        private MenuPermissionHandlerInterface $menuPermissionHandler,
        private SettingsProviderInterface $settingsProvider,
    ) {
    }

    public function build(MenuBuilderEvent $menuBuilderEvent): void
    {
        $settings = $this->settingsProvider->provide();

        if (!$settings->isEnabled()) {
            return;
        }

        /** @var MenuItem $menu */
        $menu = $menuBuilderEvent->getMenu();

        $this->menuPermissionHandler->handle($menu);
    }
}
