<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Menu;

use Dedi\SyliusAclPlugin\PermissionMap\PermissionMapInterface;
use Dedi\SyliusAclPlugin\Resolver\PermissionResolverInterface;
use Knp\Menu\MenuItem;

final class MenuPermissionHandler implements MenuPermissionHandlerInterface
{
    public function __construct(
        private PermissionMapInterface $permissionMap,
        private PermissionResolverInterface $adminPermissionResolver,
        private array $specialIndexRoutes = [],
    ) {
    }

    public function handle(MenuItem $parent): void
    {
        /** @var MenuItem $child */
        foreach ($parent->getChildren() as $child) {
            $extras = $child->getExtras();

            if (array_key_exists('routes', $extras) && is_array($extras['routes'])) {
                $toRemove = false;
                foreach ($extras['routes'] as $route) {
                    if (false === $this->adminPermissionResolver->hasPermission($route['route'])) {
                        $toRemove = true;

                        break;
                    }
                }

                $hasIndexPermission = $this->hasIndexPermission($child->getName(), $extras);

                if ($toRemove && false === $hasIndexPermission) {
                    $parent->removeChild($child->getName());
                }
            }

            $this->handle($child);
        }
    }

    private function hasIndexPermission(string $nodeName, array $extras): bool
    {
        if (0 === count($extras['routes'])) {
            return false;
        }

        if (array_key_exists($nodeName, $this->specialIndexRoutes)) {
            return $this->adminPermissionResolver->hasPermission($this->specialIndexRoutes[$nodeName]);
        }

        if (!array_key_exists('route', $extras['routes'][0])) {
            return false;
        }

        $firstRoute = $extras['routes'][0]['route'];
        $explodedRoute = explode('_', $firstRoute);
        array_pop($explodedRoute);
        $indexRoute = implode('_', $explodedRoute) . '_index';

        $supportedRouteMap = $this->permissionMap->getMap();
        if (false === array_key_exists($indexRoute, $supportedRouteMap)) {
            return false;
        }

        return $this->adminPermissionResolver->hasPermission($indexRoute);
    }

    public function removeOrphans(MenuItem $parent): void
    {
        /** @var MenuItem $child */
        foreach ($parent->getChildren() as $child) {
            if (0 === count($child->getChildren())) {
                $parent->removeChild($child->getName());
            }
        }
    }
}
