<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Menu;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Knp\Menu\MenuItem;
use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

final class AclMenuBuilder
{
    public function __construct(
        private SettingsProviderInterface $settingsProvider,
    ) {
    }

    public function build(MenuBuilderEvent $menuBuilderEvent): void
    {
        $settings = $this->settingsProvider->provide();

        if (!$settings->isEnabled()) {
            return;
        }

        /** @var MenuItem $menu */
        $menu = $menuBuilderEvent->getMenu();

        $aclMenu = $menu
            ->addChild('dedi_acl')
            ->setLabel('dedi_sylius_acl_plugin.ui.permission_management')
        ;
        $aclMenu
            ->addChild('roles', [
                'route' => 'dedi_sylius_acl_plugin_admin_role_index',
            ])
            ->setLabel('dedi_sylius_acl_plugin.ui.roles')
            ->setLabelAttribute('icon', 'key icon')
        ;
    }
}
