<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Form\Type;

use Sylius\Bundle\ResourceBundle\Form\EventSubscriber\AddCodeFormSubscriber;
use Sylius\Bundle\ResourceBundle\Form\Type\AbstractResourceType;
use Sylius\Bundle\ResourceBundle\Form\Type\ResourceTranslationsType;
use Symfony\Component\Form\DataTransformerInterface;
use Symfony\Component\Form\FormBuilderInterface;

final class RoleType extends AbstractResourceType
{
    /**
     * @param DataTransformerInterface<array, array> $dataTransformer
     */
    public function __construct(
        private DataTransformerInterface $dataTransformer,
        string $dataClass,
        $validationGroups = [],
    ) {
        parent::__construct($dataClass, $validationGroups);
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->addEventSubscriber(new AddCodeFormSubscriber())
            ->add('translations', ResourceTranslationsType::class, [
                'entry_type' => RoleTranslationType::class,
            ])
            ->add('permissions', PermissionCollectionType::class, [
                'required' => false,
            ]);

        $builder->get('permissions')->addModelTransformer($this->dataTransformer);
    }

    public function getBlockPrefix(): string
    {
        return 'dedi_sylius_acl_plugin_role';
    }
}
