<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Form\Type;

use Dedi\SyliusAclPlugin\PermissionMap\PermissionMapInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

final class PermissionCollectionType extends AbstractType
{
    public function __construct(
        private PermissionMapInterface $permissionMap,
    ) {
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $permissions = $this->permissionMap->getMap([], true);

        foreach ($permissions as $resource => $actions) {
            $builder
                ->add($resource, ChoiceType::class, [
                    'label' => 'dedi_sylius_acl_plugin.group.' . $resource,
                    'multiple' => true,
                    'choices' => $this->getChoices($actions),
                    'required' => false,
                    'expanded' => true,
                ]);
        }
    }

    private function getChoices(array $actions): array
    {
        $choices = [];
        foreach ($actions as $resource => $action) {
            $choices += [$resource => 'dedi_sylius_acl_plugin.' . $action];
        }

        return array_flip($choices);
    }
}
