<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Form\Extension;

use Dedi\SyliusAclPlugin\Form\Type\RoleAutocompleteChoiceType;
use Sylius\Bundle\AdminBundle\Form\Type\AdminUserType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\FormBuilderInterface;

final class AdminUserTypeExtension extends AbstractTypeExtension
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('aclRoles', RoleAutocompleteChoiceType::class, [
                'label' => 'dedi_sylius_acl_plugin.ui.roles',
                'multiple' => true,
                'required' => false,
            ])
            ->add('permissionChecker', CheckboxType::class, [
                'label' => 'dedi_sylius_acl_plugin.ui.permission_checker',
            ])
        ;
    }

    public static function getExtendedTypes(): iterable
    {
        return [
            AdminUserType::class,
        ];
    }
}
