<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Form\DataTransformer;

use Dedi\SyliusAclPlugin\PermissionMap\PermissionMapInterface;
use Doctrine\Common\Collections\Collection;
use Symfony\Component\Form\DataTransformerInterface;
use Webmozart\Assert\Assert;

/**
 * @implements DataTransformerInterface<array, array>
 */
final class PermissionCollectionTransformer implements DataTransformerInterface
{
    public function __construct(
        private PermissionMapInterface $permissionMap,
    ) {
    }

    public function transform($value): array
    {
        if (null === $value) {
            $value = [];
        }

        $tree = $this->permissionMap->getMap([], true);
        $form = [];

        foreach ($tree as $resource => $actions) {
            foreach ($value as $permissionMap) {
                $this->buildFormSegment($permissionMap, $form, $actions, $resource);
            }
        }

        return $form;
    }

    public function reverseTransform($value): array
    {
        Assert::isArray($value, Collection::class);

        $permissions = [];
        foreach ($value as $item) {
            foreach ($item as $i) {
                $permissions[] = $i;
            }
        }

        return $permissions;
    }

    private function buildFormSegment(
        string $routePermissionsMap,
        array &$form,
        array $actions,
        string $resource,
    ): void {
        if (!in_array($routePermissionsMap, array_keys($actions), true)) {
            return;
        }

        if (array_key_exists($resource, $form)) {
            $form[$resource][] = $routePermissionsMap;

            return;
        }

        $form[$resource] = [$routePermissionsMap];
    }
}
