<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Exception;

use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException as BaseAccessDeniedHttpException;

final class PermissionDeniedHttpException extends BaseAccessDeniedHttpException
{
    public function __construct(
        string $permission,
        \Exception $previous = null,
        int $code = 0,
    ) {
        $message = sprintf('Permission "%s" denied.', $permission);

        parent::__construct($message, $previous, $code);
    }
}
