<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\EventListener;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusAclPlugin\Exception\PermissionDeniedHttpException;
use Dedi\SyliusAclPlugin\Resolver\PermissionResolverInterface;
use Symfony\Component\HttpKernel\Event\RequestEvent;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

final class RequestPermissionListener
{
    public function __construct(
        private PermissionResolverInterface $permissionResolver,
        private SettingsProviderInterface $settingsProvider,
    ) {
    }

    public function onKernelRequest(RequestEvent $event): void
    {
        $route = $event->getRequest()->get('_route');

        if (!\is_string($route)) {
            return;
        }

        $settings = $this->settingsProvider->provide();

        if (!$settings->isEnabled() && str_contains($route, 'dedi_sylius_acl_')) {
            throw new NotFoundHttpException();
        }

        if (!$this->permissionResolver->hasPermission($route)) {
            throw new PermissionDeniedHttpException($route);
        }
    }
}
