<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Entity;

use Sylius\Component\Resource\Model\CodeAwareInterface;
use Sylius\Component\Resource\Model\ResourceInterface;
use Sylius\Component\Resource\Model\TranslatableInterface;

interface RoleInterface extends ResourceInterface, TranslatableInterface, CodeAwareInterface
{
    public function getName(): ?string;

    public function setName(?string $name): static;

    public function getPermissions(): array;

    public function addPermission(string $permission): static;

    public function removePermission(string $permission): static;

    public function hasPermission(string $permission): bool;
}
