<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Entity;

use Sylius\Component\Resource\Model\TranslatableTrait;

class Role implements RoleInterface
{
    use TranslatableTrait {
        __construct as protected initializeTranslations;
    }

    protected ?int $id = null;

    protected ?string $code = null;

    protected array $permissions = [];

    public function __construct()
    {
        $this->initializeTranslations();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $code): void
    {
        $this->code = $code;
    }

    public function getName(): ?string
    {
        /** @var RoleTranslationInterface $translation */
        $translation = $this->getTranslation();

        return $translation->getName();
    }

    public function setName(?string $name): static
    {
        /** @var RoleTranslationInterface $translation */
        $translation = $this->getTranslation();

        $translation->setName($name);

        return $this;
    }

    public function getPermissions(): array
    {
        return $this->permissions;
    }

    public function addPermission(string $permission): static
    {
        if (!$this->hasPermission($permission)) {
            $this->permissions[] = $permission;
        }

        return $this;
    }

    public function removePermission(string $permission): static
    {
        if ($this->hasPermission($permission)) {
            unset($this->permissions[array_search($permission, $this->permissions, true)]);
            $this->permissions = array_values($this->permissions);
        }

        return $this;
    }

    public function hasPermission(string $permission): bool
    {
        return \in_array($permission, $this->getPermissions(), true);
    }

    protected function createTranslation(): RoleTranslationInterface
    {
        return new RoleTranslation();
    }
}
