<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    /**
     * @psalm-suppress UnusedVariable
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_acl_plugin');
        $rootNode = $treeBuilder->getRootNode();

        $this->addConfiguration($rootNode);

        return $treeBuilder;
    }

    private function addConfiguration(ArrayNodeDefinition $node): void
    {
        $node
            ->children()
                ->scalarNode('enabled')
                    ->defaultValue(true)
                    ->info('Enable ACL in Sylius')
                ->end()
                ->arrayNode('permissions')
                ->useAttributeAsKey('name')
                ->prototype('array')
                    ->children()
                        ->booleanNode('enabled')->defaultTrue()->end()
                        ->scalarNode('label')->defaultNull()->end()
                        ->scalarNode('group')->defaultNull()->end()
                    ->end()
                ->end()
            ->end()
        ;
    }
}
