<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin;

use Dedi\SyliusAclPlugin\DependencyInjection\Compiler\CompositeAuthorizationCheckerPass;
use Dedi\SyliusAclPlugin\DependencyInjection\Compiler\CompositePermissionMapPass;
use Dedi\SyliusAclPlugin\DependencyInjection\Compiler\CompositeRouteCheckerPass;
use Dedi\SyliusAclPlugin\DependencyInjection\Compiler\CompositeRouteLabelResolverPass;
use Sylius\Bundle\CoreBundle\Application\SyliusPluginTrait;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;

final class DediSyliusAclPlugin extends Bundle
{
    use SyliusPluginTrait;

    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        $container->addCompilerPass(new CompositeRouteCheckerPass());
        $container->addCompilerPass(new CompositeRouteLabelResolverPass());
        $container->addCompilerPass(new CompositePermissionMapPass());
        $container->addCompilerPass(new CompositeAuthorizationCheckerPass());
    }

    public function getPath(): string
    {
        return \dirname(__DIR__);
    }
}
