<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Controller\Api;

use Dedi\SyliusAclPlugin\PermissionMap\PermissionMapInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;

class GetAllPermissionsController extends AbstractController
{
    public function __construct(
        private readonly PermissionMapInterface $permissionMap,
    ) {
    }

    public function __invoke(): JsonResponse
    {
        return $this->json($this->permissionMap->getMap([], true));
    }
}
