<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Controller\Api;

use Dedi\SyliusAclPlugin\PermissionMap\PermissionMapInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;

class CheckPermissionController extends AbstractController
{
    public function __construct(
        private readonly PermissionMapInterface $permissionMap,
    ) {
    }

    public function __invoke(string $permissionCode): JsonResponse
    {
        $permissions = $this->permissionMap->getMap([], true);

        $permissionExists = false;
        foreach ($permissions as $key => $permission) {
            if (array_key_exists($permissionCode, $permission)) {
                $permissionExists = true;

                break;
            }
        }

        return $this->json($permissionExists);
    }
}
