<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Cache;

use Dedi\SyliusAclPlugin\PermissionMap\PermissionMapInterface;
use Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerInterface;

final class PermissionMapCacheWarmer implements CacheWarmerInterface
{
    public function __construct(
        private PermissionMapInterface $permissionMap,
    ) {
    }

    public function isOptional(): bool
    {
        return false;
    }

    public function warmUp(string $cacheDir, ?string $buildDir = null): array
    {
        $this->permissionMap->getMap([], true);
        $this->permissionMap->getMap();

        return [];
    }
}
