<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\Cache;

use Dedi\SyliusAclPlugin\PermissionMap\PermissionMapInterface;
use Symfony\Component\HttpKernel\CacheClearer\CacheClearerInterface;
use Symfony\Contracts\Cache\CacheInterface;

final class PermissionMapCacheClearer implements CacheClearerInterface
{
    public function __construct(
        private CacheInterface $cacheAdapter,
    ) {
    }

    public function clear(string $cacheDir): void
    {
        foreach (PermissionMapInterface::CACHE_CLEARER_KEYS as $key) {
            $this->cacheAdapter->delete($key);
        }
    }
}
