<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\AuthorizationChecker;

use Dedi\SyliusAclPlugin\Resolver\PermissionResolverInterface;
use Sylius\Bundle\ResourceBundle\Controller\AuthorizationCheckerInterface as ResourceAuthorizationCheckerInterface;
use Sylius\Bundle\ResourceBundle\Controller\RequestConfiguration;

final class ResourceAuthorizationChecker implements ResourceAuthorizationCheckerInterface
{
    public function __construct(
        private PermissionResolverInterface $adminPermissionResolver,
    ) {
    }

    public function isGranted(RequestConfiguration $configuration, string $permission): bool
    {
        $routeName = $configuration->getRequest()->get('_route');

        if (!\is_string($routeName)) {
            return true;
        }

        return $this->adminPermissionResolver->hasPermission($routeName);
    }
}
