<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\AuthorizationChecker;

use Dedi\SyliusAclPlugin\Provider\AdminUserProviderInterface;

final class PermissionChecker implements AuthorizationCheckerInterface
{
    public function __construct(
        private AdminUserProviderInterface $adminUserProvider,
    ) {
    }

    public function isGranted(string $permission = null): bool
    {
        if (null === $permission) {
            return true;
        }

        $adminUser = $this->adminUserProvider->provide();

        if (null === $adminUser) {
            return false;
        }

        foreach ($adminUser->getAclRoles() as $role) {
            if ($role->hasPermission($permission)) {
                return true;
            }
        }

        return false;
    }
}
