<?php

declare(strict_types=1);

namespace Dedi\SyliusAclPlugin\AuthorizationChecker;

use Laminas\Stdlib\PriorityQueue;

final class CompositeAuthorizationChecker implements AuthorizationCheckerInterface
{
    /** @var PriorityQueue<AuthorizationCheckerInterface, int> */
    private PriorityQueue $authorizationCheckers;

    public function __construct()
    {
        $this->authorizationCheckers = new PriorityQueue();
    }

    public function addAuthorizationChecker(AuthorizationCheckerInterface $authorizationChecker, int $priority = 0): void
    {
        $this->authorizationCheckers->insert($authorizationChecker, $priority);
    }

    public function isGranted(string $permission = null): bool
    {
        foreach ($this->authorizationCheckers as $authorizationChecker) {
            if (!$authorizationChecker->isGranted($permission)) {
                return false;
            }
        }

        return true;
    }
}
