document.querySelectorAll('[data-permissions]').forEach((perm) => {
  const badge = perm.querySelector('[data-badge]');
  const toggles = perm.querySelectorAll('[data-toggles] input');
  const toggleAll = perm.querySelector('[data-toggle-all]');

  const updateBadge = () => {
    const checkedCount = Array.from(toggles).filter(toggle => toggle.checked).length;
    badge.innerText = `${checkedCount}/${toggles.length}`;
    badge.classList.toggle('teal', checkedCount > 0);
  };

  const updateToggleAll = () => {
    toggleAll.checked = Array.from(toggles).every(toggle => toggle.checked);
  };

  const toggleAllHandler = () => {
    const isChecked = toggleAll.checked;
    toggles.forEach(toggle => toggle.checked = isChecked);
    updateBadge();
  };

  const toggleHandler = () => {
    updateBadge();
    updateToggleAll();
  };

  toggleAll.addEventListener('change', toggleAllHandler);
  toggles.forEach(toggle => toggle.addEventListener('change', toggleHandler));

  updateBadge();
  updateToggleAll();
});
